<?php
/*
Plugin Name: EDM Reports
Description: A nice plugin for EDM Reports
Version: 0.1
*/

// plugin folder url
if(!defined('EDM_REPORTS_PLUGIN_URL')) {
	define('EDM_REPORTS_PLUGIN_URL', plugin_dir_url( __FILE__ ));
}

/*
|--------------------------------------------------------------------------
| MAIN CLASS
|--------------------------------------------------------------------------
*/

class edm_reports {
	
	/* --------------------------------------------*
	* Attributes
	* -------------------------------------------- */
	
	/** Refers to a single instance of this class. */
	
	private static $instance = null;
	
	/* Saved options */
	public $options;
	
	/* --------------------------------------------*
	* Constructor
	* -------------------------------------------- */
	
	/**
	* Creates or returns an instance of this class.
	*
	* @return WPMU_Theme_Options A single instance of this class.
	*/
	public static function get_instance() {
	
		if (null == self::$instance) {
			self::$instance = new self;
		}
	
		return self::$instance;
	}
	
	// end get_instance;
 
	/*--------------------------------------------*
	 * Constructor
	 *--------------------------------------------*/
 
	/**
	 * Initializes the plugin by setting localization, filters, and administration functions.
	 */
	function __construct() {
		global $wpdb;
		add_action( 'init', array( &$this, 'create_campaign') );
		add_shortcode( 'EDM-Report', array( &$this, 'edm_report') );
		
		add_action('wp_ajax_load_campaign', array( &$this,'load_campaign'));
		add_action('wp_ajax_nopriv_load_campaign', array( &$this,'load_campaign'));
		
	}
	
	function create_campaign() {
		register_post_type( 'campaign',
			array(
				'labels' => array(
				'name' => __( 'Campaigns' ),
				'singular_name' => __( 'Campaign' ),
			),
			'public' => true,
			'hierarchical'  => false,
			'show_in_menu' => true,
			'has_archive' => false,
			'rewrite' => array('slug' => 'campaign'),
			)
		);

		$labels = array(
			'name'              => _x( 'Clients', 'taxonomy general name', 'textdomain' ),
			'singular_name'     => _x( 'Client', 'taxonomy singular name', 'textdomain' ),
			'search_items'      => __( 'Search Clients', 'textdomain' ),
			'all_items'         => __( 'All Clients', 'textdomain' ),
			'parent_item'       => __( 'Parent Client', 'textdomain' ),
			'parent_item_colon' => __( 'Parent Client:', 'textdomain' ),
			'edit_item'         => __( 'Edit Client', 'textdomain' ),
			'update_item'       => __( 'Update Client', 'textdomain' ),
			'add_new_item'      => __( 'Add New Client', 'textdomain' ),
			'new_item_name'     => __( 'New Client Name', 'textdomain' ),
			'menu_name'         => __( 'Clients', 'textdomain' ),
		);
	
		$args = array(
			'hierarchical'      => true,
			'labels'            => $labels,
			'show_ui'           => true,
			'show_admin_column' => true,
			'query_var'         => true,
			'rewrite'           => array( 'slug' => 'client' ),
		);
	
		register_taxonomy( 'client', array( 'campaign' ), $args );

		// wp_enqueue_script( 'jquery_min', '//cdn.jsdelivr.net/jquery/1/jquery.min.js' );
		wp_enqueue_script( 'moment_min', '//cdn.jsdelivr.net/momentjs/latest/moment.min.js' );
		
		wp_enqueue_style( 'bootstrap', '//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css' );
		
		wp_enqueue_script( 'daterangepicker', '//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.js' );
		 
		wp_enqueue_style( 'daterangepicker', '//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css' );

	}
	
	function edm_report( $atts ) { ?>
    	<form name="FilterForm" id="FilterForm" method="post" action="" >
            <select name="cmbClient" id="cmbClient" onchange="cmbClientChange(this.value);">
				<option value="">Select</option><?php
                $terms = get_terms( array(
                    'taxonomy' => 'client',
                    'hide_empty' => false,
                ) );
                if($terms) {
                    foreach($terms as $term) {?>
                        <option value="<?php echo $term->term_id;?>" <?php if(isset($_POST['cmbClient']) && $_POST['cmbClient']==$term->term_id ) {?> selected="selected"<?php }?>><?php echo $term->name;?></option><?php
                    }
                }?>
            </select>
			<div id="Campaign">
            <select name="cmbCampaign" id="cmbCampaign">
				<option value="">Select</option><?php
				if(isset($_POST['cmbClient']) && $_POST['cmbClient']!='') {
					$args = array(
						'post_type' => 'campaign',
						'tax_query' => array(
							array(
								'taxonomy' => 'client',
								'field' => 'term_id',
								'terms' => $_POST['cmbClient']
							)
						)
					);
					$the_query = new WP_Query( $args );
					while ( $the_query->have_posts() ) :
						$the_query->the_post();?>
						<option value="<?php echo get_the_ID();?>" <?php if(isset($_POST['cmbCampaign']) && $_POST['cmbCampaign']==get_the_ID() ) {?> selected="selected"<?php }?>><?php echo get_the_title(); ?></option><?php
					endwhile;
				}?>
            </select>
            </div>
			<input type="text" name="daterange" value="<?php if(isset($_POST['daterange']) && $_POST['daterange']!='' ) { echo $_POST['daterange']; } else { ?>01/01/2017 - 01/31/2017<?php }?>" />
			<script type="text/javascript">
            $(function() {
                $('input[name="daterange"]').daterangepicker();
            });
			
			function cmbClientChange(id) {
				$.ajax({
					url:"<?php echo admin_url( 'admin-ajax.php' ); ?>",
					type:'POST',
					datatype: "html",
					data: { 
						action: 'load_campaign', 
						id : id,
					},
					success: function(html) {
						jQuery("#Campaign").html(html);
					},
					error: function() {
						alert('error handing here');
					}
				});
			}
            </script>
            <input type="submit" name="btnSubmit" value="Filter" id="btnSubmit" />
		</form><?php

		//print_r($_POST);
		//MailingId ReportId
		global $wpdb;
		$sql = "SELECT * FROM imc_mailing_summary WHERE 1=1";
		if(isset($_POST['cmbClient']) && $_POST['cmbClient']!="" && $_POST['cmbCampaign']=="") {
			
			$post_ids = get_posts(array(
				'post_type' => 'campaign',
				'numberposts'   => -1, // get all posts.
				'tax_query'     => array(
					array(
						'taxonomy'  => 'client',
						'field'     => 'term_id',
						'terms'     => $_POST['cmbClient'],
					),
				),
				'fields'        => 'ids', // Only get post IDs
			));
			
			$MailingId = array();
			$ReportId = array();
			foreach($post_ids as $post_id) {
				$MailingId[] = get_post_meta($post_id, 'mailing_id', true);
				$ReportId[] = get_post_meta($post_id, 'report_id', true);
			}
			if(count($MailingId)>0) {
				$sql .= " AND MailingId IN (".implode(',',$MailingId).')';
			}
			if(count($ReportId)>0) {
				$sql .= " AND ReportId IN (".implode(',',$ReportId).')';
			}
				//AND ReportId=$ReportId";
			//echo $sql;
			//print_r( $post_ids );
			
			
			
			/*$args = array(
	'post_type' => 'campaign',
	'tax_query' => array(
		array(
			'taxonomy' => 'client',
			'field' => 'term_id',
			'terms' => $_POST['cmbClient']
		)
	)
);
$query = new WP_Query( $args );*/

		}
		
		if(isset($_POST['cmbCampaign']) && $_POST['cmbCampaign']!="") {
			$MailingId = get_post_meta($_POST['cmbCampaign'], 'mailing_id', true);
			$ReportId = get_post_meta($_POST['cmbCampaign'], 'report_id', true);
			$sql .= " AND MailingId=$MailingId AND ReportId=$ReportId";
		}
		//$MailingId=27792683;
		//$ReportId=981360734;

		
		if(isset($_POST['daterange']) && $_POST['daterange']!="") {
			$daterange_arr = explode('-', $_POST['daterange']);
			$start_arr = explode('/', trim($daterange_arr[0]));
			$start = $start_arr[2].'-'.$start_arr[0].'-'.$start_arr[1]. '';
			
			$end_arr = explode('/', trim($daterange_arr[1]));
			$end = $end_arr[2].'-'.$end_arr[0].'-'.$end_arr[1];
			
			//$sql.=" AND SentDateTime>=";
			$sql .= " AND SentDateTime>='".$start." 00:00:00' AND SentDateTime<='".$end." 23:59:59'";
		}
		
		
		
		$post_meta_infos = $wpdb->get_results( $sql );
		if (count($post_meta_infos)!=0) {?>
			<div class="report-data">
            <table>
            	<thead>
                	<th>MailingId</th>
                    <th>ReportId</th>
                    <th>MailingName</th>
                    <th>SentDateTime</th>
                    <th>NumSent</th>
                    <th>NumReceived</th>
                    <th>pdelivered</th>
                    <th>NumSeeds</th>
                    <th>NumSuppressed</th>
                    <th>psuppressed</th>
                    <th>NumInboxMonitored</th>
                    <th>NumBounceHard</th>
                    <th>NumBounceSoft</th>
                    <th>pbouncehard</th>
                    <th>pbouncesoft</th>
                    <th>NumBounceTotal</th>
                    <th>pbouncetotal</th>
                    <th>NumUniqueOpen</th>
                    <th>puopens</th>
                    <th>NumGrossOpen</th>
                    <th>NumUniqueClick</th>
                    <th>NumGrossClick</th>
                    <th>NumUniqueAttach</th>
                    <th>NumGrossAttach</th>
                    <th>NumUniqueClickstreams</th>
                    <th>NumGrossClickstreams</th>
                    <th>NumUniqueMedia</th>
                    <th>NumGrossMedia</th>
                    <th>NumGrossAbuse</th>
                    <th>pgrossabuse</th>
                    <th>NumGrossChangeAddress</th>
                    <th>pgrosschangeaddress</th>
                    <th>NumGrossMailBlock</th>
                    <th>pgrossmailblock</th>
                    <th>NumGrossMailRestriction</th>
                    <th>pgrossmailrestriction</th>
                    <th>NumGrossOther</th>
                    <th>pgrossother</th>
                    <th>NumConversions</th>
                    <th>NumConversionAmount</th>
                    <th>NumBounceHardFwd</th>
                    <th>NumBounceSoftFwd</th>
                    <th>NumConversionAmountFwd</th>
                    <th>NumAttachOpenFwd</th>
                    <th>NumClickFwd</th>
                    <th>NumUniqueForwardFwd</th>
                    <th>NumGrossForwardFwd</th>
                    <th>NumUniqueConversionsFwd</th>
                    <th>NumGrossConversionsFwd</th>
                    <th>NumUniqueClickstreamFwd</th>
                    <th>NumGrossClickstreamFwd</th>
                    <th>NumUniqueClickFwd</th>
                    <th>NumGrossClickFwd</th>
                    <th>NumUniqueAttachOpenFwd</th>
                    <th>NumGrossAttachOpenFwd</th>
                    <th>NumUniqueMediaFwd</th>
                    <th>NumGrossMediaFwd</th>
                    <th>NumUniqueOpenFwd</th>
                    <th>NumGrossOpenFwd</th>
                    <th>NumAbuseFwd</th>
                    <th>NumChangeAddressFwd</th>
                    <th>NumMailRestrictionFwd</th>
                    <th>NumMailBlockFwd</th>
                    <th>NumOtherFwd</th>
                    <th>NumSuppressedFwd</th>
                    <th>NumUnsubscribes</th>
                 </thead><?php   
			foreach ($post_meta_infos as $meta_info) {?>
				<tr>
					<td><?php echo $meta_info->MailingId; ?></td>
                    <td><?php echo $meta_info->ReportId; ?></td>
                    <td><?php echo $meta_info->MailingName; ?></td>
                    <td><?php echo $meta_info->SentDateTime; ?></td>
                    <td><?php echo $meta_info->NumSent; ?></td>
                    <td><?php echo $meta_info->NumReceived; ?></td>
                    <td><?php echo $meta_info->pdelivered; ?></td>
                    <td><?php echo $meta_info->NumSeeds; ?></td>
                    <td><?php echo $meta_info->NumSuppressed; ?></td>
                    <td><?php echo $meta_info->psuppressed; ?></td>
                    <td><?php echo $meta_info->NumInboxMonitored; ?></td>
                    <td><?php echo $meta_info->NumBounceHard; ?></td>
                    <td><?php echo $meta_info->NumBounceSoft; ?></td>
                    <td><?php echo $meta_info->pbouncehard; ?></td>
                    <td><?php echo $meta_info->pbouncesoft; ?></td>
                    <td><?php echo $meta_info->NumBounceTotal; ?></td>
                    <td><?php echo $meta_info->pbouncetotal; ?></td>
                    <td><?php echo $meta_info->NumUniqueOpen; ?></td>
                    <td><?php echo $meta_info->puopens; ?></td>
                    <td><?php echo $meta_info->NumGrossOpen; ?></td>
                    <td><?php echo $meta_info->NumUniqueClick; ?></td>
                    <td><?php echo $meta_info->NumGrossClick; ?></td>
                    <td><?php echo $meta_info->NumUniqueAttach; ?></td>
                    <td><?php echo $meta_info->NumGrossAttach; ?></td>
                    <td><?php echo $meta_info->NumUniqueClickstreams; ?></td>
                    <td><?php echo $meta_info->NumGrossClickstreams; ?></td>
                    <td><?php echo $meta_info->NumUniqueMedia; ?></td>
                    <td><?php echo $meta_info->NumGrossMedia; ?></td>
                    <td><?php echo $meta_info->NumGrossAbuse; ?></td>
                    <td><?php echo $meta_info->pgrossabuse; ?></td>
                    <td><?php echo $meta_info->NumGrossChangeAddress; ?></td>
                    <td><?php echo $meta_info->pgrosschangeaddress; ?></td>
                    <td><?php echo $meta_info->NumGrossMailBlock; ?></td>
                    <td><?php echo $meta_info->pgrossmailblock; ?></td>
                    <td><?php echo $meta_info->NumGrossMailRestriction; ?></td>
                    <td><?php echo $meta_info->pgrossmailrestriction; ?></td>
                    <td><?php echo $meta_info->NumGrossOther; ?></td>
                    <td><?php echo $meta_info->pgrossother; ?></td>
                    <td><?php echo $meta_info->NumConversions; ?></td>
                    <td><?php echo $meta_info->NumConversionAmount; ?></td>
                    <td><?php echo $meta_info->NumBounceHardFwd; ?></td>
                    <td><?php echo $meta_info->NumBounceSoftFwd; ?></td>
                    <td><?php echo $meta_info->NumConversionAmountFwd; ?></td>
                    <td><?php echo $meta_info->NumAttachOpenFwd; ?></td>
                    <td><?php echo $meta_info->NumClickFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueForwardFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossForwardFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueConversionsFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossConversionsFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueClickstreamFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossClickstreamFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueClickFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossClickFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueAttachOpenFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossAttachOpenFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueMediaFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossMediaFwd; ?></td>
                    <td><?php echo $meta_info->NumUniqueOpenFwd; ?></td>
                    <td><?php echo $meta_info->NumGrossOpenFwd; ?></td>
                    <td><?php echo $meta_info->NumAbuseFwd; ?></td>
                    <td><?php echo $meta_info->NumChangeAddressFwd; ?></td>
                    <td><?php echo $meta_info->NumMailRestrictionFwd; ?></td>
                    <td><?php echo $meta_info->NumMailBlockFwd; ?></td>
                    <td><?php echo $meta_info->NumOtherFwd; ?></td>
                    <td><?php echo $meta_info->NumSuppressedFwd; ?></td>
                    <td><?php echo $meta_info->NumUnsubscribes; ?></td>
				</tr><?php
			}?>
            </table></div><?php
		}
	}
	
	function load_campaign() {
		$str_campaign='';
		$str_campaign='<select name="cmbCampaign" id="cmbCampaign">
			<option value="">Select</option>';
			$args = array(
				'post_type' => 'campaign',
				'tax_query' => array(
					array(
						'taxonomy' => 'client',
						'field' => 'term_id',
						'terms' => $_POST['id']
					)
				)
			);
			$the_query = new WP_Query( $args );
			while ( $the_query->have_posts() ) :
				$the_query->the_post();
				$str_campaign.='<option value="'.get_the_ID().'">'.get_the_title().'</option>';
			endwhile;
		$str_campaign.='</select>';
		echo $str_campaign;
		die();
	}

}

// instantiate plugin's class
$GLOBALS['edm_reports'] = new edm_reports(); 
?>